/**
 * PCM dispatch driver Z for FMP <ocye> for Windows
 * PPZ8 Extender "Z8X" for Windows
 *
 * Original PDZF Programmed by Kossestsu-Inryo
 * Original Z8X & Windows Version Programmed by Y.Taniuchi ( TAN-Y )
 *
 * Special Thanks C60 ( WinFMP & PPZ8L.cpp/.h ), Kossetsu-Inryo ( PDZF )
 */

#ifndef _PDZFZ8X_INTF_
#define _PDZFZ8X_INTF_

#include <windows.h>
#include "PDZFZ8X_workdef.h"

// {BE634311-5E33-4aef-B36B-6C1E406150ED}
static const GUID IID_ITimerBNotify = 
{ 0xbe634311, 0x5e33, 0x4aef, { 0xb3, 0x6b, 0x6c, 0x1e, 0x40, 0x61, 0x50, 0xed } };

// {72841E29-EC6F-45c4-AAFF-4F4EDE9A4F67}
static const GUID IID_IPDZFZ8X = 
{ 0x72841e29, 0xec6f, 0x45c4, { 0xaa, 0xff, 0x4f, 0x4e, 0xde, 0x9a, 0x4f, 0x67 } };

#pragma pack(1)

typedef struct stereo16bittag
{
	short left;
	short right;
} Stereo16bit;

#pragma pack()


/**
 * TimerBʒmCxgC^[tF[X`
 *
 * @author Y.Taniuchi
 */
class ITimerBNotify
	: public IUnknown
{
public:
	virtual HRESULT STDMETHODCALLTYPE OnTimerB(
		BOOL blTimerBNotify, Stereo16bit *pSamples, int iSampleCnt) = 0;
};


/**
 * PDZFZ8XJC^[tF[X`
 *
 * @author Y.Taniuchi ( TAN-Y )
 */
class IPDZFZ8X
	: public IUnknown
{
public:
	virtual DWORD STDMETHODCALLTYPE GetVersion() = 0;
	virtual DWORD STDMETHODCALLTYPE GetExtendPPZ8SequenceMode() = 0;
	virtual HRESULT STDMETHODCALLTYPE SetExtendPPZ8SequenceMode(
		DWORD dwMode) = 0;
	virtual DWORD STDMETHODCALLTYPE GetPlayingExtendPPZ8SequenceStatus() = 0;
	virtual HRESULT STDMETHODCALLTYPE GetPDZFWork(
		PDZFWORK **ppPDZFWork) = 0;
	virtual HRESULT STDMETHODCALLTYPE GetZ8XWork(
		Z8XWORK **ppZ8XWork) = 0;
	virtual HRESULT STDMETHODCALLTYPE RegisterTimerBNotify(
		ITimerBNotify *pRegistNotify,
		ITimerBNotify **ppOldNotify) = 0;
};


#endif
